# Biometric Fingerprint Based School Attendance Management System

## Project Overview
This is a comprehensive biometric fingerprint-based attendance management system designed for schools. The system provides accurate attendance tracking using fingerprint authentication, with a user-friendly interface and robust admin controls.

## Features

### Core Features
- **Fingerprint Registration**: Register student/staff fingerprint with unique ID assignment
- **Attendance Marking**: Fingerprint scan to mark attendance with automatic date/time recording
- **User-Friendly Interface**: Large buttons, clear instructions, and touch-screen friendly design
- **Real-time Feedback**: Success/error prompts with color-coded feedback (Green = Success, Red = Error)
- **Admin Panel**: Comprehensive admin interface for user management and reporting
- **Detailed Reports**: Class-wise, student-wise, and monthly attendance summaries

### Security Features
- Secure admin login with JWT token authentication
- Password hashing with bcrypt
- Input validation and sanitization
- Rate limiting for login attempts
- XSS and SQL injection protection
- Encrypted data transmission

## Technology Stack

### Frontend
- HTML5
- CSS3
- JavaScript (ES6+)

### Backend
- Node.js
- Express.js
- JWT for authentication

### Database
- MySQL (compatible with SQLite)

### Security
- bcrypt for password hashing
- JWT tokens for session management
- Input validation and sanitization
- Rate limiting

## Project Structure
```
BiometricAttendanceSystem/
├── frontend/
│   ├── css/
│   │   ├── style.css
│   │   └── admin-style.css
│   ├── js/
│   │   ├── main.js
│   │   └── admin.js
│   ├── images/
│   ├── index.html
│   └── admin.html
├── backend/
│   ├── api/
│   ├── controllers/
│   ├── middleware/
│   │   └── security.js
│   ├── models/
│   ├── server.js
│   ├── security.js
│   └── package.json
├── database/
│   └── schema.sql
└── docs/
```

## Installation

1. Clone the repository
2. Navigate to the backend directory: `cd BiometricAttendanceSystem/backend`
3. Install dependencies: `npm install`
4. Set up the database using the schema in `database/schema.sql`
5. Configure environment variables (optional):
   - DB_HOST
   - DB_USER
   - DB_PASSWORD
   - DB_NAME
   - JWT_SECRET
   - SESSION_SECRET
6. Start the server: `npm start`

## Usage

### For Students/Staff:
1. Place finger on the scanner to mark attendance
2. Receive immediate feedback on attendance status
3. System prevents duplicate entries for the same day

### For Administrators:
1. Access admin panel with username/password
2. Manage users (add/edit/delete)
3. View detailed attendance reports
4. Export reports in various formats

## Security Measures Implemented

1. **Authentication**: JWT tokens with expiration
2. **Authorization**: Role-based access control
3. **Password Security**: Bcrypt hashing with salt
4. **Input Validation**: Sanitization and validation of all inputs
5. **Rate Limiting**: Prevents brute force attacks
6. **SQL Injection Prevention**: Parameterized queries
7. **XSS Protection**: Content security policies

## API Endpoints

### Public Endpoints
- `POST /api/register` - Register new user
- `POST /api/admin/login` - Admin login

### Protected Endpoints (require admin authentication)
- `POST /api/attendance/mark` - Mark attendance
- `POST /api/admin/logout` - Admin logout
- `GET /api/users` - Get all users
- `GET /api/attendance/:userId` - Get attendance for specific user
- `GET /api/attendance/daily-summary` - Daily attendance summary
- `GET /api/attendance/monthly-report` - Monthly attendance report
- `DELETE /api/users/:userId` - Delete user
- `GET /api/stats` - System statistics

## Database Schema

The system uses the following tables:
- `admins` - Admin user accounts
- `user_types` - Types of users (student, teacher, staff)
- `classes` - School classes
- `sections` - Class sections
- `users` - Registered users
- `fingerprints` - Encrypted fingerprint templates
- `attendance` - Attendance records
- `system_settings` - System configuration
- `audit_logs` - System audit trail

## Fingerprint Scanner Integration

The system is designed to work with standard fingerprint scanner SDKs. The frontend JavaScript includes simulated functionality that would connect to actual hardware in a production environment.

## Admin Panel Features

- Dashboard with system statistics
- User management (CRUD operations)
- Daily attendance tracking
- Monthly reports with visualizations
- System configuration settings
- Audit logging

## Future Enhancements

- Integration with actual fingerprint scanner hardware
- Mobile app development
- Email/SMS notifications
- Advanced reporting analytics
- Multi-location support
- Offline mode capability

## License

This project is licensed under the MIT License - see the LICENSE file for details.